
import React from 'react';
import { Link } from 'react-router-dom';
import { Button } from './ui';

const Footer = () => {
  return (
    <footer className="bg-brand-bg-light border-t border-gray-200">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          <div>
            <h3 className="text-xl font-bold font-heading text-brand-purple mb-4">Lanisdeb Market</h3>
            <p className="text-brand-text-light">Your source for authentic African & Caribbean groceries.</p>
          </div>
          <div>
            <h4 className="font-heading font-semibold text-brand-text-dark mb-4">Quick Links</h4>
            <ul className="space-y-2">
              <li><Link to="/" className="hover:text-brand-purple transition-colors">Home</Link></li>
              <li><Link to="/shop" className="hover:text-brand-purple transition-colors">Shop</Link></li>
              <li><Link to="/cart" className="hover:text-brand-purple transition-colors">Your Cart</Link></li>
              <li><Link to="/profile" className="hover:text-brand-purple transition-colors">My Account</Link></li>
            </ul>
          </div>
          <div>
            <h4 className="font-heading font-semibold text-brand-text-dark mb-4">Information</h4>
            <ul className="space-y-2">
              <li><a href="#" className="hover:text-brand-purple transition-colors">About Us</a></li>
              <li><a href="#" className="hover:text-brand-purple transition-colors">Contact Us</a></li>
              <li><a href="#" className="hover:text-brand-purple transition-colors">Privacy Policy</a></li>
              <li><a href="#" className="hover:text-brand-purple transition-colors">Terms of Service</a></li>
            </ul>
          </div>
          <div>
            <h4 className="font-heading font-semibold text-brand-text-dark mb-4">Newsletter</h4>
            <p className="mb-4">Subscribe for updates and special offers.</p>
            <form className="flex">
              <input type="email" placeholder="Your email" className="w-full px-4 py-2 border border-gray-300 rounded-l-md focus:ring-brand-purple focus:border-brand-purple" />
              <Button type="submit" className="rounded-l-none">
                Go
              </Button>
            </form>
          </div>
        </div>
        <div className="text-center text-brand-text-light mt-12 border-t border-gray-200 pt-8">
          <p>&copy; {new Date().getFullYear()} Lanisdeb African & Caribbean Market. All Rights Reserved.</p>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
