import React, { useState } from 'react';
import { Link, NavLink } from 'react-router-dom';
import { useCart } from '../context/CartContext';
import { useBranding } from '../context/BrandingContext';
import { ShoppingBag, User, Menu, X } from 'lucide-react';

const Header = () => {
  const { cartCount } = useCart();
  const { logo } = useBranding();
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  const navLinkClassFunc = ({ isActive }: { isActive: boolean }) =>
    `text-brand-text-dark hover:text-brand-purple transition-colors duration-200 font-semibold ${isActive ? 'text-brand-purple' : ''}`;

  const navLinks = (
    <>
      <NavLink to="/" end className={navLinkClassFunc} onClick={() => setIsMenuOpen(false)}>Home</NavLink>
      <NavLink to="/shop" className={navLinkClassFunc} onClick={() => setIsMenuOpen(false)}>Shop</NavLink>
      <NavLink to="/admin" className={navLinkClassFunc} onClick={() => setIsMenuOpen(false)}>Admin</NavLink>
    </>
  );

  return (
    <header className="bg-background/80 backdrop-blur-lg sticky top-0 z-40 shadow-sm">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex items-center justify-between h-20">
          <div className="flex items-center space-x-8">
            <Link to="/">
              <img src={logo} alt="Lanisdeb Market Logo" className="h-16" />
            </Link>
          </div>

          <nav className="hidden md:flex items-center space-x-8">
            {navLinks}
          </nav>

          <div className="flex items-center space-x-5">
            <NavLink to="/profile" className="text-brand-text-dark hover:text-brand-purple transition-colors duration-200 hidden sm:block">
              <User size={24} />
            </NavLink>
            <NavLink to="/cart" className="relative text-brand-text-dark hover:text-brand-purple transition-colors duration-200">
              <ShoppingBag size={24} />
              {cartCount > 0 && (
                <span className="absolute -top-2 -right-2 bg-brand-gold text-white text-xs font-bold rounded-full h-5 w-5 flex items-center justify-center">
                  {cartCount}
                </span>
              )}
            </NavLink>
            <div className="md:hidden">
              <button onClick={() => setIsMenuOpen(!isMenuOpen)} className="text-brand-text-dark">
                {isMenuOpen ? <X size={28} /> : <Menu size={28} />}
              </button>
            </div>
          </div>
        </div>
      </div>
      {isMenuOpen && (
        <div className="md:hidden bg-background pb-4">
          <nav className="flex flex-col items-center space-y-4">
            {navLinks}
             <NavLink to="/profile" className={navLinkClassFunc} onClick={() => setIsMenuOpen(false)}>Profile</NavLink>
          </nav>
        </div>
      )}
    </header>
  );
};

export default Header;