
import React from 'react';
import { useCart } from '../context/CartContext';
import { CheckCircle } from 'lucide-react';

const Toast = () => {
  const { toastMessages } = useCart();

  return (
    <div className="fixed bottom-5 right-5 z-50 space-y-2">
      {toastMessages.map((toast) => (
        <div
          key={toast.id}
          className="bg-brand-text-dark text-white rounded-lg shadow-lg p-4 flex items-center space-x-3 animate-fade-in-up"
        >
          <CheckCircle className="text-green-400" size={24} />
          <span>{toast.message}</span>
          <style>{`
            @keyframes fade-in-up {
              0% { opacity: 0; transform: translateY(20px); }
              100% { opacity: 1; transform: translateY(0); }
            }
            .animate-fade-in-up {
              animation: fade-in-up 0.5s ease-out forwards;
            }
          `}</style>
        </div>
      ))}
    </div>
  );
};

export default Toast;
