import React, { createContext, useState, useContext, useEffect, useCallback } from 'react';
import { useNavigate } from 'react-router-dom';
import { ADMIN_PASSWORD } from '../constants';

interface AuthContextType {
    isLoggedIn: boolean;
    login: (password: string) => boolean;
    logout: () => void;
}

const AuthContext = createContext<AuthContextType | undefined>(undefined);

export const useAuth = () => {
    const context = useContext(AuthContext);
    if (!context) {
        throw new Error('useAuth must be used within an AuthProvider');
    }
    return context;
};

const AUTH_KEY = 'lanisdeb-admin-auth';

export const AuthProvider = ({ children }: React.PropsWithChildren<{}>) => {
    const [isLoggedIn, setIsLoggedIn] = useState(false);
    const navigate = useNavigate();

    useEffect(() => {
        const storedAuth = localStorage.getItem(AUTH_KEY);
        if (storedAuth === 'true') {
            setIsLoggedIn(true);
        }
    }, []);

    const login = (password: string): boolean => {
        if (password === ADMIN_PASSWORD) {
            localStorage.setItem(AUTH_KEY, 'true');
            setIsLoggedIn(true);
            navigate('/admin');
            return true;
        }
        return false;
    };

    const logout = useCallback(() => {
        localStorage.removeItem(AUTH_KEY);
        setIsLoggedIn(false);
        navigate('/admin/login');
    }, [navigate]);

    const value = { isLoggedIn, login, logout };

    return <AuthContext.Provider value={value}>{children}</AuthContext.Provider>;
};
