
import { useEffect, useRef } from 'react';

function useDocumentTitle(title: string, prevailOnUnmount = false) {
  const defaultTitle = useRef(document.title);

  useEffect(() => {
    document.title = `${title} | Lanisdeb Market`;
  }, [title]);

  useEffect(() => {
    const originalTitle = defaultTitle.current;
    return () => {
      if (!prevailOnUnmount) {
        document.title = originalTitle;
      }
    };
  }, [prevailOnUnmount]);
}

export default useDocumentTitle;
