
import React from 'react';
import { Link } from 'react-router-dom';
import { Button } from '../components/ui';

const NotFoundPage = () => {
  return (
    <div className="flex flex-col items-center justify-center text-center py-20 px-4 min-h-[calc(100vh-20rem)]">
      <h1 className="text-6xl font-bold font-heading text-brand-purple">404</h1>
      <h2 className="text-3xl font-bold text-brand-text-dark mt-4">Page Not Found</h2>
      <p className="text-lg text-brand-text-light mt-2">
        Sorry, the page you are looking for does not exist.
      </p>
      <Button asChild size="lg" className="mt-8">
        <Link to="/">Go back to Homepage</Link>
      </Button>
    </div>
  );
};

export default NotFoundPage;
