import React from 'react';
import { useLocation, Link, Navigate } from 'react-router-dom';
import { Order } from '../types';
import { CheckCircle } from 'lucide-react';
import { Button } from '../components/ui';

const OrderSuccessPage: React.FC = () => {
  const location = useLocation();
  const order: Order | undefined = location.state?.order;

  if (!order) {
    return <Navigate to="/" replace />;
  }

  return (
    <div className="bg-brand-bg-light">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div className="bg-white max-w-2xl mx-auto rounded-lg shadow p-8 text-center">
          <CheckCircle className="text-green-500 w-20 h-20 mx-auto mb-4" />
          <h1 className="text-3xl font-bold font-heading text-brand-text-dark mb-2">Thank you for your order!</h1>
          <p className="text-brand-text-light mb-6">Your order has been placed successfully and will be delivered soon.</p>
          
          <div className="text-left bg-green-50 border-l-4 border-green-500 text-green-800 p-4 rounded-md mb-6" role="alert">
            <p className="font-bold">Confirmation Sent</p>
            <p>A confirmation email with your order details has been sent to <strong>{order.customerDetails.email}</strong>.</p>
          </div>

          <div className="bg-brand-bg-light rounded-lg p-6 text-left my-6 border">
            <h2 className="text-xl font-bold font-heading mb-4">Order Summary</h2>
            <p className="mb-2"><strong>Order ID:</strong> #{order.id}</p>
            <p className="mb-2"><strong>Total:</strong> <span className="font-bold">${order.total.toFixed(2)}</span></p>
            <p className="mb-2"><strong>Payment Method:</strong> {order.paymentMethod}</p>
            <h3 className="font-bold mt-4 mb-2">Items:</h3>
            <ul className="list-disc list-inside text-sm space-y-1">
              {order.items.map(item => (
                <li key={item.id}>{item.name} (x{item.quantity})</li>
              ))}
            </ul>
          </div>
          <Button asChild size="lg" className="mt-8">
            <Link to="/shop">Continue Shopping</Link>
          </Button>
        </div>
      </div>
    </div>
  );
};

export default OrderSuccessPage;